<?php $__env->startSection('title','View System Info'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
        <div>
          <h5 class="mb-1"><i class="fa-regular fa-eye me-2"></i>System Info Details</h5>
          <p class="text-muted mb-0">Full record preview</p>
        </div>
        <div class="d-flex gap-2 flex-wrap">
          <a href="<?php echo e(route('system-infos.edit', $systemInfo->id)); ?>" class="btn btn-outline-primary">
            <i class="fa-regular fa-pen-to-square me-1"></i>Edit
          </a>
          <a href="<?php echo e(route('system-infos.index')); ?>" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-1"></i>Back
          </a>
        </div>
      </div>

      <hr>

      <div class="row g-3">
        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">Company Name</div>
          <div><?php echo e($systemInfo->company_name ?? '-'); ?></div>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">Email</div>
          <div><?php echo e($systemInfo->address ?? '-'); ?></div>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">Phone</div>
          <div><?php echo e($systemInfo->phone ?? '-'); ?></div>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">WhatsApp Number</div>
          <div><?php echo e($systemInfo->whatsapp_number ?? '-'); ?></div>
        </div>

        <div class="col-12">
          <div class="fw-semibold text-muted">Footer Copy Right</div>
          <div><?php echo e($systemInfo->footer_copey_right ?? '-'); ?></div>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">Logo</div>
          <?php if($systemInfo->logo): ?>
            <img src="<?php echo e(asset('storage/'.$systemInfo->logo)); ?>" class="mt-1"
                 style="width:60px;height:60px;object-fit:cover;border-radius:12px;border:1px solid rgba(0,0,0,.08);">
          <?php else: ?>
            <div>-</div>
          <?php endif; ?>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">Favicon</div>
          <?php if($systemInfo->favicon): ?>
            <img src="<?php echo e(asset('storage/'.$systemInfo->favicon)); ?>" class="mt-1"
                 style="width:60px;height:60px;object-fit:cover;border-radius:12px;border:1px solid rgba(0,0,0,.08);">
          <?php else: ?>
            <div>-</div>
          <?php endif; ?>
        </div>
      </div>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/system_infos/show.blade.php ENDPATH**/ ?>