<?php $__env->startSection('title','View Upload App'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
        <div>
          <h5 class="mb-1"><i class="fa-regular fa-eye me-2"></i>Uploaded App Details</h5>
          <p class="text-muted mb-0">APK file info</p>
        </div>

        <div class="d-flex gap-2 flex-wrap">
          <a href="<?php echo e(route('upload-apps.edit', $uploadApp->id)); ?>" class="btn btn-outline-primary">
            <i class="fa-regular fa-pen-to-square me-1"></i>Edit
          </a>
          <a href="<?php echo e(route('upload-apps.index')); ?>" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-1"></i>Back
          </a>
        </div>
      </div>

      <hr>

      <div class="row g-3">
        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">App Name</div>
          <div><?php echo e($uploadApp->app_name ?? '-'); ?></div>
        </div>

        <div class="col-12 col-lg-6">
          <div class="fw-semibold text-muted">APK</div>
          <?php if($uploadApp->apk_file): ?>
            <div class="d-flex align-items-center gap-2 flex-wrap">
              <span class="badge bg-success">
                <i class="fa-brands fa-android me-1"></i>Uploaded
              </span>
              <span class="text-muted small"><?php echo e(basename($uploadApp->apk_file)); ?></span>
            </div>

            <div class="mt-2">
              <a href="<?php echo e(route('upload-apps.download', $uploadApp->id)); ?>" class="btn btn-outline-success btn-sm">
                <i class="fa-solid fa-download me-1"></i>Download APK
              </a>
            </div>
          <?php else: ?>
            <div>-</div>
          <?php endif; ?>
        </div>
      </div>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/upload_apps/show.blade.php ENDPATH**/ ?>