<?php
    $systemInfo = \App\Models\SystemInfo::first();
    $appName = $systemInfo ? $systemInfo->company_name : 'Admin Dashboard';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="Qf3vM5KhUFYaEmCx3AQEc2WLPy6N4rXr7wTjHqaY" />
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($appName); ?></title>
    <?php if(optional($systemInfo)->favicon): ?>

        <link rel="icon" href="<?php echo e(asset('storage/' . $systemInfo->favicon)); ?>" type="image/x-icon" />
    <?php else: ?>

        <link rel="icon" href="<?php echo e(asset('assets/logo-d.png')); ?>" type="image/x-icon" />
    <?php endif; ?>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Rubik:400,400i,500,500i,700,700i&display=swap"
        rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Roboto:300,300i,400,400i,500,500i,700,700i,900&display=swap"
        rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fontawesome.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/icofont.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/themify.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/flag-icon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/feather-icon.css')); ?>" />

    <!-- Vendor / Plugins CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/slick.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/slick-theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/jquery.dataTables.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/select.bootstrap5.css')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <!-- Tailwind (if you really need it) -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Bootstrap + App CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors/bootstrap.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>" />
    <link id="color" rel="stylesheet" href="<?php echo e(asset('assets/css/color-1.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/responsive.css')); ?>" />

    <style>
        /* Toastr background overrides */
        .toast-success {
            background-color: #4CAF50 !important;
            color: #fff !important;
        }

        .toast-error {
            background-color: #F44336 !important;
            color: #fff !important;
        }

        .toast-info {
            background-color: #2196F3 !important;
            color: #fff !important;
        }

        .toast-warning {
            background-color: #FF9800 !important;
            color: #fff !important;
        }

        #custom-icon {
            width: 22px;
            height: 22px;
            margin-right: 10px;
            transition: all 0.3s ease;
        }

        #custom-dash-icon {
            width: 35px;
            height: 35px;
            transition: all 0.3s ease;
        }
    </style>
</head>

<body onload="startTime()">
    <!-- Loader -->
    <div class="loader-wrapper">
        <div class="loader-index"><span></span></div>
        <svg>
            <filter id="goo">
                <fegaussianblur in="SourceGraphic" stddeviation="11" result="blur"></fegaussianblur>
                <fecolormatrix in="blur" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 19 -9" result="goo">
                </fecolormatrix>
            </filter>
        </svg>
    </div>

    <!-- Tap on top -->
    <div class="tap-top"><i data-feather="chevrons-up"></i></div>

    <!-- page-wrapper Start -->
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <!-- Page Header Start -->
        <div class="page-header">
            <div class="header-wrapper row m-0">
                <form class="form-inline search-full col" action="#" method="get">
                    <div class="form-group w-100">
                        <div class="Typeahead Typeahead--twitterUsers">
                            <div class="u-posRelative">
                                <input class="demo-input Typeahead-input form-control-plaintext w-100" type="text"
                                    placeholder="Search Anything Here..." name="q" autofocus />
                                <div class="spinner-border Typeahead-spinner" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <i class="close-search" data-feather="x"></i>
                            </div>
                            <div class="Typeahead-menu"></div>
                        </div>
                    </div>
                </form>

                <div class="header-logo-wrapper col-auto p-0">
                    <div class="logo-wrapper">
                        <a href="<?php echo e(url('/dashboard')); ?>">

                            <?php if(optional($systemInfo)->logo): ?>
                                <img src="<?php echo e(asset('storage/' . $systemInfo->logo)); ?>" class="h-8 rounded" alt="logo">
                            <?php else: ?>
                                <img class="img-fluid for-dark" src="<?php echo e(asset('assets/logo-d.png')); ?>" alt="logo">
                            <?php endif; ?>

                        </a>
                    </div>
                    <div class="toggle-sidebar">
                        <i class="status_toggle middle sidebar-toggle" data-feather="align-center"></i>
                    </div>
                </div>

                <div class="nav-right col-xxl-7 col-xl-6 col-md-7 col-8 pull-right right-header p-0 ms-auto">
                    <ul class="nav-menus">
                        <li class="fullscreen-body">
                            <span>
                                <svg id="maximize-screen">
                                    <use
                                        href="https://necwev.serverpoint.top/assets/svg/icon-sprite.svg#full-screen">
                                    </use>
                                </svg>
                            </span>
                        </li>

                        <li>
                            <span class="header-search">
                                <svg>
                                    <use
                                        href="https://necwev.serverpoint.top/assets/svg/icon-sprite.svg#search">
                                    </use>
                                </svg>
                            </span>
                        </li>

                        <li>
                            <div class="mode">
                                <svg>
                                    <use
                                        href="https://necwev.serverpoint.top/assets/svg/icon-sprite.svg#moon">
                                    </use>
                                </svg>
                            </div>
                        </li>



                        <li class="profile-nav onhover-dropdown pe-0 py-0">
                            <div class="d-flex profile-media">


                                <?php
                                    // $avatar = auth()->user()->profile_image ? asset('storage/' . auth()->user()->profile_image) : null;
                                    $initial = strtoupper(substr(auth()->user()->name ?? 'A', 0, 1));
                                ?>

                                





                                <div class="flex-grow-1">
                                    <span></span>
                                    <p class="mb-0">
                                        <?php echo e(auth()->user()->name ?? 'N/A'); ?>

                                        <i class="middle fa-solid fa-angle-down"></i>
                                    </p>
                                </div>
                            </div>

                            <ul class="profile-dropdown onhover-show-div">
                                <li>
                                    <a style="display: flex;" href="<?php echo e(url('admin/profile')); ?>">
                                        <i data-feather="user"></i><span>Account</span>
                                    </a>
                                </li>
                                <li>
                                    <a style="display: flex;" href="<?php echo e(url('system-infos')); ?>">
                                        <i data-feather="settings"></i><span>Settings</span>
                                    </a>
                                </li>

                                <li>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button style="display: flex;" type="submit"
                                            class="btn btn-link p-0 m-0 text-decoration-none">
                                            <i data-feather="log-in"></i> <span>Log out</span>
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>

                <!-- Typeahead templates -->
                <script class="result-template" type="text/x-handlebars-template">
          <div class="ProfileCard u-cf">
            <div class="ProfileCard-avatar">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                   stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                   class="feather feather-airplay m-0">
                <path d="M5 17H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2h-1"></path>
                <polygon points="12 15 17 21 7 21 12 15"></polygon>
              </svg>
            </div>
            <div class="ProfileCard-details">
              <div class="ProfileCard-realName"></div>
            </div>
          </div>
        </script>

                <script class="empty-template" type="text/x-handlebars-template">
          <div class="EmptyMessage">
            Your search turned up 0 results. This most likely means the backend is down, yikes!
          </div>
        </script>
            </div>
        </div>
        <!-- Page Header Ends -->

        <!-- Page Body Start -->
        <div class="page-body-wrapper">
            <!-- Sidebar -->
            <div class="sidebar-wrapper" data-sidebar-layout="stroke-svg">
                <div>
                    <div class="logo-wrapper">
                        <a href="<?php echo e(url('/dashboard')); ?>">
                            <?php if(optional($systemInfo)->logo): ?>
                                <img style="width:70%;height:49px;" src="<?php echo e(asset('storage/' . $systemInfo->logo)); ?>"
                                    class="h-8 rounded" alt="logo">
                            <?php else: ?>
                                <img style="width:70%;height:49px;" class="img-fluid for-dark"
                                    src="<?php echo e(asset('assets/logo-d.png')); ?>" alt="logo">
                            <?php endif; ?>


                        </a>
                        <div class="back-btn"><i class="fa-solid fa-angle-left"></i></div>
                        <div class="toggle-sidebar">
                            <i class="status_toggle middle sidebar-toggle" data-feather="layout"></i>


                        </div>
                    </div>

                    <div class="logo-icon-wrapper">
                        <a href="<?php echo e(url('/dashboard')); ?>">
                            <?php if(optional($systemInfo)->logo): ?>
                                <img style="width:70%;height:49px;" src="<?php echo e(asset('storage/' . $systemInfo->logo)); ?>"
                                    class="h-8 rounded" alt="logo">
                            <?php else: ?>
                                <img style="width:70%;height:49px;" class="img-fluid for-dark"
                                    src="<?php echo e(asset('assets/logo-d.png')); ?>" alt="logo">
                            <?php endif; ?>

                        </a>
                    </div>

                    <nav class="sidebar-main">
                        <div class="left-arrow" id="left-arrow"><i data-feather="arrow-left"></i></div>

                        <div id="sidebar-menu">
                            <ul class="sidebar-links" data-simplebar>

                                <li class="sidebar-main-title">
                                    <div>
                                        <h6>General</h6>
                                    </div>
                                </li>

                                <li class="sidebar-list">
                                    <a class="sidebar-link sidebar-title link-nav" href="<?php echo e(url('/dashboard')); ?>">
                                        <i class="bi bi-speedometer2 me-2"></i>
                                        <span>Dashboard</span>
                                    </a>
                                </li>

                                
                                <li class="sidebar-list">
                                    <a class="sidebar-link sidebar-title" href="javascript:void(0)">
                                        <i class="bi bi-gear me-2"></i>
                                        <span>App Settings</span>
                                        <div class="according-menu">
                                            <i class="fa fa-angle-right"></i>
                                        </div>
                                    </a>

                                    <ul class="sidebar-submenu">
                                        <li><a href="<?php echo e(route('system-infos.index')); ?>">System Info</a></li>
                                        <li><a href="<?php echo e(route('upload-apps.index')); ?>">Upload App</a></li>
                                        <li><a href="<?php echo e(route('headlines.index')); ?>">Add Headlines</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>

                        <div class="right-arrow" id="right-arrow"><i data-feather="arrow-right"></i></div>
                    </nav>


                </div>
            </div>


            <!-- Sidebar Ends -->

            <div class="page-body" style="padding: 20px !important;">

                <div class="container-fluid default-dashboard "
                    style="padding-bottom: 41px !important;display: inline;">
                    <?php if(session('ok')): ?>
                        <div class="mb-4 p-3 bg-green-50 border border-green-200 rounded">
                            <?php echo e(session('ok')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="mb-4 p-3 bg-red-50 border border-red-200 rounded text-red-700">
                            <?php echo e($errors->first()); ?>

                        </div>
                    <?php endif; ?>

                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <!-- Footer -->
            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12 footer-copyright text-center">
                            <p class="mb-0">
                                Copyright <span class="year-update"></span> © <?php echo e(optional($systemInfo)->footer_copey_right); ?> . All rights reserved.
                            </p>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Core JS -->
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Icons -->
    <script src="<?php echo e(asset('assets/js/icons/feather-icon/feather.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/icons/feather-icon/feather-icon.js')); ?>"></script>

    <!-- Vendor / Plugins JS -->
    <script src="<?php echo e(asset('assets/js/scrollbar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/scrollbar/custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sidebar-menu.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sidebar-pin.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/clock.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/slick/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/slick/slick.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/header-slick.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/chart/apex-chart/apex-chart.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chart/apex-chart/stock-prices.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/counter/counter-custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dashboard/default.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/dataTables.select.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/select.bootstrap5.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatable.custom.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/typeahead/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.bundle.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead/typeahead.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead-search/handlebars.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/typeahead-search/typeahead-custom.js')); ?>"></script>

    <!-- Toastr + Sweetalert -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!-- Theme -->
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/script1.js')); ?>"></script>

    <!-- Firebase -->
    <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.sidebar-link.sidebar-title').forEach(function (btn) {
                const li = btn.closest('.sidebar-list');
                const submenu = li ? li.querySelector('.sidebar-submenu') : null;
                if (!submenu) return;

                btn.addEventListener('click', function (e) {
                    // only for submenu titles (not link-nav)
                    if (btn.classList.contains('link-nav')) return;

                    e.preventDefault();
                    li.classList.toggle('open');
                });
            });
        });
    </script>

</body>

</html>
<?php /**PATH /home2/serverpo/necwev.serverpoint.top/resources/views/admin/master.blade.php ENDPATH**/ ?>