<?php $__env->startSection('title','System Infos'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa-solid fa-circle-check me-2"></i><?php echo e(session('success')); ?>

      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">System Infos</h4>
    
    </div>

    <a href="<?php echo e(route('system-infos.create')); ?>" class="btn btn-primary">
      <i class="fa-solid fa-plus me-2"></i>Add New
    </a>
  </div>

  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <?php if($systemInfos->count() === 0): ?>
        <div class="text-center p-5 text-muted">
          <i class="fa-regular fa-folder-open fa-2x mb-2"></i>
          <div class="fw-semibold">No records yet</div>
          <div class="small">Click “Add New” to create your first system info.</div>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Company</th>
                <th>Logo</th>
                <th>Favicon</th>
                <th>Phone</th>
                <th>Whatsapp</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>

            <tbody>
              <?php $__currentLoopData = $systemInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-muted"><?php echo e($systemInfos->firstItem() + $i); ?></td>
                  <td class="fw-semibold"><?php echo e($info->company_name ?? '-'); ?></td>

                  <td>
                    <?php if($info->logo): ?>
                      <img src="<?php echo e(asset('storage/'.$info->logo)); ?>" alt="logo"
                           style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
                    <?php else: ?>
                      <span class="badge bg-secondary">N/A</span>
                    <?php endif; ?>
                  </td>

                  <td>
                    <?php if($info->favicon): ?>
                      <img src="<?php echo e(asset('storage/'.$info->favicon)); ?>" alt="favicon"
                           style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
                    <?php else: ?>
                      <span class="badge bg-secondary">N/A</span>
                    <?php endif; ?>
                  </td>

                  <td><?php echo e($info->phone ?? '-'); ?></td>
                  <td><?php echo e($info->whatsapp_number ?? '-'); ?></td>

                  <td class="text-end">
                    <div class="d-flex gap-2 justify-content-end flex-wrap">
                      <a href="<?php echo e(route('system-infos.show', $info->id)); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="fa-regular fa-eye me-1"></i>View
                      </a>

                      <a href="<?php echo e(route('system-infos.edit', $info->id)); ?>" class="btn btn-outline-primary btn-sm">
                        <i class="fa-regular fa-pen-to-square me-1"></i>Edit
                      </a>

                      <form action="<?php echo e(route('system-infos.destroy', $info->id)); ?>" method="POST"
                            onsubmit="return confirm('Delete this record?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-outline-danger btn-sm">
                          <i class="fa-regular fa-trash-can me-1"></i>Delete
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          <?php echo e($systemInfos->links()); ?>

        </div>
      <?php endif; ?>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/system_infos/index.blade.php ENDPATH**/ ?>