<?php $__env->startSection('title','Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  
  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Dashboard</h4>
      <p class="text-muted mb-0">Quick overview of your system</p>
    </div>

    
    <div class="d-flex gap-2 flex-wrap">
      <a href="<?php echo e(route('upload-apps.create')); ?>" class="btn btn-primary">
        <i class="fa-solid fa-upload me-2"></i>Upload App
      </a>
      <a href="<?php echo e(route('headlines.create')); ?>" class="btn btn-outline-primary">
        <i class="fa-regular fa-newspaper me-2"></i>Add Headline
      </a>
      <a href="<?php echo e(route('system-infos.create')); ?>" class="btn btn-outline-secondary">
        <i class="fa-solid fa-gear me-2"></i>System Info
      </a>
    </div>
  </div>

  
  <div class="row g-3 mb-3">
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Total Users</div>
            <div class="fs-3 fw-bold"><?php echo e($totalUsers); ?></div>
          </div>
          <div class="fs-2 text-primary">
            <i class="fa-solid fa-users"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="#" class="small text-decoration-none">
            Manage Users <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Uploaded Apps</div>
            <div class="fs-3 fw-bold"><?php echo e($totalApps); ?></div>
          </div>
          <div class="fs-2 text-success">
            <i class="fa-brands fa-android"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="<?php echo e(route('upload-apps.index')); ?>" class="small text-decoration-none">
            View Apps <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Headlines</div>
            <div class="fs-3 fw-bold"><?php echo e($totalHeadlines); ?></div>
          </div>
          <div class="fs-2 text-warning">
            <i class="fa-regular fa-newspaper"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="<?php echo e(route('headlines.index')); ?>" class="small text-decoration-none">
            View Headlines <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">System Infos</div>
            <div class="fs-3 fw-bold"><?php echo e($totalSystemInfo); ?></div>
          </div>
          <div class="fs-2 text-secondary">
            <i class="fa-solid fa-gear"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="<?php echo e(route('system-infos.index')); ?>" class="small text-decoration-none">
            View Settings <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>
  </div>

  
  <div class="row g-3">

    
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <h6 class="fw-semibold mb-3">
            <i class="fa-solid fa-building me-2"></i>Company Info
          </h6>

          <?php if($systemInfo): ?>
            <div class="d-flex align-items-center gap-3 mb-3">
              <?php if($systemInfo->logo): ?>
                <img src="<?php echo e(asset('storage/'.$systemInfo->logo)); ?>"
                     style="width:54px;height:54px;object-fit:cover;border-radius:14px;border:1px solid rgba(0,0,0,.08);">
              <?php else: ?>
                <div class="bg-light d-flex align-items-center justify-content-center"
                     style="width:54px;height:54px;border-radius:14px;">
                  <i class="fa-solid fa-image text-muted"></i>
                </div>
              <?php endif; ?>

              <div>
                <div class="fw-bold"><?php echo e($systemInfo->company_name ?? 'N/A'); ?></div>
                <div class="small text-muted"><?php echo e($systemInfo->address ?? 'No address'); ?></div>
              </div>
            </div>

            <div class="small">
              <div class="mb-2">
                <i class="fa-solid fa-phone me-2 text-muted"></i><?php echo e($systemInfo->phone ?? '-'); ?>

              </div>
              <div class="mb-2">
                <i class="fa-brands fa-whatsapp me-2 text-muted"></i><?php echo e($systemInfo->whatsapp_number ?? '-'); ?>

              </div>
              <div class="text-muted">
                <i class="fa-regular fa-copyright me-2"></i><?php echo e($systemInfo->footer_copey_right ?? '-'); ?>

              </div>
            </div>

          <?php else: ?>
            <div class="text-center p-4 text-muted">
              <i class="fa-solid fa-circle-info fa-2x mb-2"></i>
              <div class="fw-semibold">No system info added</div>
              <div class="small">Add company settings to show here.</div>
              <a href="<?php echo e(route('system-infos.create')); ?>" class="btn btn-sm btn-outline-secondary mt-3">
                <i class="fa-solid fa-plus me-1"></i>Add System Info
              </a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-brands fa-android me-2"></i>Latest Apps
            </h6>
            <a href="<?php echo e(route('upload-apps.index')); ?>" class="small text-decoration-none">View all</a>
          </div>

          <?php $__empty_1 = true; $__currentLoopData = $latestApps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="d-flex justify-content-between align-items-start py-2 border-bottom">
              <div>
                <div class="fw-semibold"><?php echo e($app->app_name ?? 'Untitled App'); ?></div>
                <div class="small text-muted">
                  <?php echo e($app->created_at?->format('d M Y')); ?>

                </div>
              </div>

              <?php if($app->apk_file): ?>
                <a class="btn btn-sm btn-outline-success"
                   href="<?php echo e(route('upload-apps.download', $app->id)); ?>">
                  <i class="fa-solid fa-download"></i>
                </a>
              <?php endif; ?>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center p-4 text-muted">
              <i class="fa-solid fa-box-open mb-2"></i>
              <div>No apps uploaded yet</div>
            </div>
          <?php endif; ?>

        </div>
      </div>
    </div>

    
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-regular fa-newspaper me-2"></i>Latest Headlines
            </h6>
            <a href="<?php echo e(route('headlines.index')); ?>" class="small text-decoration-none">View all</a>
          </div>

          <?php $__empty_1 = true; $__currentLoopData = $latestHeadlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="py-2 border-bottom">
              <div class="fw-semibold text-truncate">
                <?php echo e(\Illuminate\Support\Str::limit(strip_tags($h->top_headlines), 60)); ?>

              </div>
              <div class="small text-muted">
                <?php echo e(\Illuminate\Support\Str::limit(strip_tags($h->body_headlines), 70)); ?>

              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center p-4 text-muted">
              <i class="fa-regular fa-newspaper mb-2"></i>
              <div>No headlines added yet</div>
            </div>
          <?php endif; ?>

        </div>
      </div>
    </div>

    
    <div class="col-12">
      <div class="card border-0 shadow-sm rounded-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-solid fa-users me-2"></i>Latest Users
            </h6>
          </div>

          <div class="table-responsive">
            <table class="table align-middle mb-0">
              <thead class="table-light">
                <tr>
                  <th>#</th>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Joined</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $latestUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td class="text-muted"><?php echo e($i + 1); ?></td>
                    <td class="fw-semibold"><?php echo e($u->name); ?></td>
                    <td><?php echo e($u->email); ?></td>
                    <td class="text-muted"><?php echo e($u->created_at?->format('d M Y')); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted p-4">
                      No users found
                    </td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>

  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>