<?php
    $download_app = \App\Models\UploadApp::first();
    $Headline = \App\Models\Headline::first();
    $systemInfo = \App\Models\SystemInfo::first();
    $appName = $systemInfo ? $systemInfo->company_name : 'Admin Dashboard';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($appName); ?></title>
    <?php if(optional($systemInfo)->favicon): ?>

        <link rel="icon" href="<?php echo e(asset('storage/' . $systemInfo->favicon)); ?>" type="image/x-icon" />
    <?php else: ?>

        <link rel="icon" href="<?php echo e(asset('assets/logo-d.png')); ?>" type="image/x-icon" />
    <?php endif; ?>
    <meta name="description"
        content="Send money from Europe and Asia to Bangladesh quickly, safely, and easily with the Nec Money  BD smartphone app. No queues, no delays, fully secure.">
    <meta name="robots" content="index, follow">

    <!-- Open Graph / Social -->
    <meta property="og:title" content="Nec Money  BD | Fast & Secure Money Transfer">
    <meta property="og:description"
        content="Send money from Europe and Asia to Bangladesh quickly, safely, and easily with the Nec Money  BD app.">
    <meta property="og:url" content="https://taptapsnsdbd.shop/">
    <meta property="og:type" content="website">
    <meta property="og:image" content="../taptapsnsdbd.shop/logo.html">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Nec Money  BD | Fast & Secure Money Transfer">
    <meta name="twitter:description"
        content="Send money from Europe and Asia to Bangladesh quickly, safely, and easily with the Nec Money  BD app.">
    <meta name="twitter:image" content="../taptapsnsdbd.shop/logo.html">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', system-ui, sans-serif;
        }

        body {
            background: #f4fff4;
            color: #1f2937;
            scroll-behavior: smooth;
            line-height: 1.6;
        }

        a {
            text-decoration: none;
        }

        img {
            max-width: 100%;
            height: auto;
        }

        /* Header */
        header {
            background: #009900;
            padding: 16px 22px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
        }

        header .logo {
            font-size: 22px;
            font-weight: 700;
            color: #ffffff;
        }

        header .logo span {
            background: #ffffff;
            color: #009900;
            padding: 4px 8px;
            border-radius: 6px;
            margin-right: 6px;
        }

        .menu-btn {
            font-size: 28px;
            color: #ffffff;
            cursor: pointer;
            user-select: none;
        }

        .overlay-menu {
            position: absolute;
            top: 60px;
            right: 22px;
            background: #ffffff;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            width: 180px;
            transform: scale(0);
            transform-origin: top right;
            transition: transform 0.3s ease-in-out;
            z-index: 100;
        }

        .overlay-menu.show {
            transform: scale(1);
        }

        .overlay-menu a {
            display: block;
            padding: 12px 18px;
            color: #009900;
            font-weight: 600;
            border-bottom: 1px solid #e0e0e0;
        }

        .overlay-menu a:hover {
            background: #f0fff0;
        }

        .overlay-menu a:last-child {
            border-bottom: none;
        }

        /* Notice */
        .notice {
            background: #e9fbe9;
            overflow: hidden;
            white-space: nowrap;
            padding: 10px 0;
        }

        .notice span {
            display: inline-block;
            padding-left: 100%;
            animation: scroll 20s linear infinite;
            font-weight: 600;
            color: #006600;
        }

        @keyframes scroll {
            from {
                transform: translateX(0);
            }

            to {
                transform: translateX(-100%);
            }
        }

        /* Hero Section */
        .hero {
            background: linear-gradient(135deg, #009900, #00b300);
            color: #ffffff;
            text-align: center;
            padding: 70px 20px;
        }

        .hero h1 {
            font-size: 34px;
            margin-bottom: 12px;
        }

        .hero p {
            font-size: 18px;
        }

        /* Download Section */
        .download {
            background: #ffffff;
            text-align: center;
            padding: 60px 20px 40px;
        }

        .download h2 {
            font-size: 30px;
            color: #009900;
            margin-bottom: 10px;
        }

        .download p {
            margin-bottom: 22px;
        }

        .download a {
            display: inline-block;
            background: #009900;
            color: #ffffff;
            padding: 15px 38px;
            border-radius: 10px;
            font-size: 18px;
            font-weight: 600;
            box-shadow: 0 10px 20px rgba(0, 153, 0, 0.3);
        }

        .flags {
            margin-top: 25px;
            overflow: hidden;
            white-space: nowrap;
        }

        .flags span {
            display: inline-block;
            padding-left: 100%;
            animation: flagScroll 25s linear infinite;
            font-size: 22px;
        }

        @keyframes flagScroll {
            from {
                transform: translateX(0);
            }

            to {
                transform: translateX(-100%);
            }
        }

        .flags-text {
            margin-top: 10px;
            font-size: 14px;
            color: #065f06;
        }

        /* Trusted Section */
        .trusted-section {
            background: #f0fff0;
            padding: 60px 20px;
        }

        .trusted-section h2 {
            text-align: center;
            color: #009900;
            margin-bottom: 40px;
        }

        .trusted-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            max-width: 1100px;
            margin: auto;
        }

        .trusted-cards .card {
            background: #ffffff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            text-align: center;
        }

        .trusted-cards .card span {
            font-size: 40px;
            display: block;
            margin-bottom: 12px;
        }

        .trusted-cards .card h3 {
            color: #009900;
            margin-bottom: 10px;
        }

        /* Contact Section */
        #contactSection {
            display: none;
            background: #ffffff;
            padding: 60px 20px;
            border-top: 2px dashed #009900;
        }

        #contactSection h2 {
            color: #009900;
            text-align: center;
            margin-bottom: 40px;
        }

        .contact-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
            max-width: 900px;
            margin: auto;
        }

        .contact-card {
            background: #f0fff0;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            text-align: center;
            transition: transform 0.2s;
        }

        .contact-card:hover {
            transform: scale(1.03);
        }

        .contact-card span {
            display: block;
            font-size: 36px;
            margin-bottom: 12px;
        }

        .contact-card h3 {
            color: #009900;
            margin-bottom: 10px;
        }

        .contact-card a {
            color: #065f06;
            text-decoration: none;
            font-weight: 600;
        }

        /* About Section */
        #aboutSection {
            display: none;
            background: #e8f7e8;
            padding: 60px 20px;
            border-top: 2px dashed #009900;
        }

        #aboutSection h2 {
            color: #009900;
            text-align: center;
            margin-bottom: 30px;
        }

        #aboutSection .about-card {
            background: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            max-width: 800px;
            margin: auto;
            text-align: center;
        }

        #aboutSection h3 {
            font-size: 24px;
            margin-bottom: 15px;
            color: #009900;
        }

        #aboutSection p {
            font-size: 16px;
            color: #065f06;
            line-height: 1.8;
        }

        /* Footer */
        footer {
            background: #064e06;
            color: #ffffff;
            text-align: center;
            padding: 22px;
            font-size: 14px;
        }

        /* WhatsApp Floating Button */
        #whatsappBtn {
            position: fixed;
            bottom: 25px;
            right: 25px;
            z-index: 9999;
            border-radius: 50%;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            transition: transform 0.2s;
        }

        #whatsappBtn:hover {
            transform: scale(1.1);
        }

        /* Mobile */
        @media(max-width:600px) {
            .hero h1 {
                font-size: 26px;
            }

            .download h2,
            .trusted-section h2,
            .contact-container h2,
            .about-card h3 {
                font-size: 24px;
            }

            .menu-btn {
                font-size: 26px;
            }
        }
    </style>
</head>

<body>

    <header>
        <div class="logo">
            <?php if(optional($systemInfo)->logo): ?>
                <img style="height: 52px;width: 100%;" src="<?php echo e(asset('storage/' . $systemInfo->logo)); ?>" alt="logo">
            <?php else: ?>
                <img style="height: 52px;width: 100%;" src="<?php echo e(asset('assets/logo1.png')); ?>" alt="logo">
            <?php endif; ?>

        </div>
        <div class="menu-btn" id="menuBtn">⋮</div>
        <nav class="overlay-menu" id="overlayMenu">
            <a href="#hero">Home</a>
            <a href="#contactSection" id="contactLink">Contact</a>
            <a href="#aboutSection" id="aboutLink">About</a>
        </nav>
    </header>

    <div class="notice"><span>
            <?php if(optional($Headline)->top_headlines): ?>
                <?php echo optional($Headline)->top_headlines; ?>

            <?php else: ?>
                ইউরোপ এবং এশিয়া কান্ট্রি থেকে দেশে টাকা পাঠান Nec Money ব্যবহার করে খুব সহজে, দ্রুত এবং
                নিরাপদে
            <?php endif; ?>

        </span></div>

    <main>
        <section class="hero" id="hero">
            <h1>Fast & Secure Money Transfer</h1>
            <p>বিদেশ থেকে বাংলাদেশে টাকা পাঠানোর নির্ভরযোগ্য সমাধান</p>
        </section>

        <!-- Download Section -->
        <section class="download">
            <h2>Download Our App</h2>
            <p>এখনই অ্যাপ ডাউনলোড করে টাকা পাঠানো শুরু করুন</p>
            <!-- Direct APK download -->


            <?php if($download_app->apk_file): ?>
                <a href="<?php echo e(route('upload-apps.download', $download_app->id)); ?>" download>
                    ⬇ Download App
                </a>

            <?php endif; ?>

            <div class="flags"><span>


                    <?php if(optional($Headline)->body_headlines): ?>
                        <?php echo optional($Headline)->body_headlines; ?>

                    <?php else: ?>
                        🇸🇦 🇲🇾 🇴🇲 🇶🇦 🇰🇼 🇧🇭 🇦🇪 🇰🇭 🇫🇯 🇲🇹 🇫🇷 🇩🇪 🇮🇹 🇪🇸 🇳🇱 🇧🇪
                        🇸🇪 🇳🇴 🇨🇭 🇵🇹
                    <?php endif; ?>

                </span></div>
            <div class="flags-text">These countries can send money to Bangladesh using Nec Money BD</div>
        </section>

        <section class="trusted-section">
            <h2>Why Trust NecMoney BD?</h2>
            <div class="trusted-cards">
                <div class="card"><span>🔒</span>
                    <h3>Secure Transactions</h3>
                </div>
                <div class="card"><span>⚡</span>
                    <h3>Fast & Reliable</h3>
                </div>
                <div class="card"><span>💰</span>
                    <h3>Transparent Fees</h3>
                </div>
                <div class="card"><span>🌐</span>
                    <h3>Global Reach</h3>
                </div>
                <div class="card"><span>📞</span>
                    <h3>Customer Support</h3>
                </div>
            </div>
        </section>

        <section id="contactSection">
            <h2>Contact Us</h2>
            <div class="contact-container">
                <div class="contact-card">
                    <span>💬</span>
                    <h3>WhatsApp</h3>
                    <a href="https://wa.me/<?php echo e(optional($systemInfo)->whatsapp_number); ?>?text=NecMMoney%20%e0%a6%86%e0%a6%ae%e0%a6%bf%20%e0%a6%86%e0%a6%aa%e0%a6%a8%e0%a6%be%e0%a6%a6%e0%a7%87%e0%a6%b0%20%e0%a6%97%e0%a7%8d%e0%a6%b0%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3%E1%B9%A3"
                        target="_blank"><?php echo e(optional($systemInfo)->whatsapp_number); ?></a>
                </div>
                <div class="contact-card">
                    <span>📱</span>
                    <h3>Mobile</h3>
                    <a href="tel:+<?php echo e(optional($systemInfo)->phone); ?>"><?php echo e(optional($systemInfo)->phone); ?></a>
                </div>
                <div class="contact-card">
                    <span>📧</span>
                    <h3>Email</h3>
                    <a href="mailto:<?php echo e(optional($systemInfo)->address); ?>"><?php echo e(optional($systemInfo)->address); ?></a>
                </div>
            </div>
        </section>

        <section id="aboutSection">
            <h2>About Nec Money BD</h2>
            <div class="about-card">
                <h3>Convenient, safe and fast.</h3>
                <p>Our easy-to-use smartphone app lets you send money to family and friends with just a few taps and a
                    debit card.
                    No more waiting in line, or wondering whether loved ones received their transfers.</p>
            </div>
        </section>
    </main>

    <footer>© 2026 <?php echo e(optional($systemInfo)->company_name); ?> · Trusted Remittance Platform</footer>

    <!-- WhatsApp Floating Button -->
    <a href="https://wa.me/<?php echo e(optional($systemInfo)->whatsapp_number); ?>?text=NecMoney%20%e0%a6%86%e0%a6%ae%e0%a6%bf%20%e0%a6%86%e0%a6%aa%e0%a6%a8%e0%a6%be%e0%a6%a6%e0%a7%87%e0%a6%b0%20%e0%a6%97%e0%a7%8d%e0%a6%b0%e0%a6%be%e0%a6%b9%e0%a6%95%20%e0%a6%b9%e0%a6%a4%e0%a7%87%20%e0%a6%9a%e0%a6%be%e0%a6%87"
        target="_blank" id="whatsappBtn" title="Chat with us on WhatsApp">
        <img src="<?php echo e(asset('assets/whatsapp.jpg')); ?>" alt="WhatsApp Chat" style="width:50px;height:50px;">
    </a>

    <script>
        // 3-dot overlay toggle
        const menuBtn = document.getElementById('menuBtn');
        const overlayMenu = document.getElementById('overlayMenu');
        menuBtn.addEventListener('click', () => { overlayMenu.classList.toggle('show'); });
        document.addEventListener('click', (e) => { if (!overlayMenu.contains(e.target) && !menuBtn.contains(e.target)) { overlayMenu.classList.remove('show'); } });

        // Contact link scroll
        const contactLink = document.getElementById('contactLink');
        const contactSection = document.getElementById('contactSection');
        contactLink.addEventListener('click', (e) => {
            e.preventDefault();
            contactSection.style.display = 'block';
            contactSection.scrollIntoView({ behavior: 'smooth' });
        });

        // About link scroll
        const aboutLink = document.getElementById('aboutLink');
        const aboutSection = document.getElementById('aboutSection');
        aboutLink.addEventListener('click', (e) => {
            e.preventDefault();
            aboutSection.style.display = 'block';
            aboutSection.scrollIntoView({ behavior: 'smooth' });
        });
    </script>

</body>

</html>
<?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/welcome.blade.php ENDPATH**/ ?>