<?php $__env->startSection('title','Upload New App'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">
      <h5 class="mb-3"><i class="fa-solid fa-upload me-2"></i>Upload New App</h5>

      
      <div class="alert alert-danger d-none" id="errorBox"></div>

      <form id="apkUploadForm" action="<?php echo e(route('upload-apps.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="row g-3">
          <div class="col-12 col-lg-6">
            <label class="form-label">App Name</label>
            <input type="text" name="app_name" class="form-control" placeholder="e.g. My App">
          </div>

          <div class="col-12 col-lg-6">
            <label class="form-label">APK File</label>
            <input type="file" name="apk_file" class="form-control" accept=".apk" required>
            <div class="form-text">Only .apk (Large file supported after server config)</div>
          </div>
        </div>

        <div class="mt-4 d-none" id="progressWrap">
          <div class="d-flex justify-content-between small mb-1">
            <span class="text-muted">Uploading...</span>
            <span class="fw-semibold"><span id="progressPercent">0</span>%</span>
          </div>
          <div class="progress" style="height: 14px;">
            <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" style="width: 0%"></div>
          </div>
          <div class="small text-muted mt-1" id="progressText">Starting...</div>
        </div>

        <div class="d-flex gap-2 mt-4 flex-wrap">
          <button type="submit" class="btn btn-primary" id="btnSubmit">
            <i class="fa-solid fa-floppy-disk me-2"></i>Upload
          </button>

          <a href="<?php echo e(route('upload-apps.index')); ?>" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
(function () {
  const form = document.getElementById('apkUploadForm');
  const btn = document.getElementById('btnSubmit');

  const errorBox = document.getElementById('errorBox');

  const progressWrap = document.getElementById('progressWrap');
  const progressBar  = document.getElementById('progressBar');
  const progressPercent = document.getElementById('progressPercent');
  const progressText = document.getElementById('progressText');

  function showError(msgHtml) {
    errorBox.classList.remove('d-none');
    errorBox.innerHTML = msgHtml;
  }

  function hideError() {
    errorBox.classList.add('d-none');
    errorBox.innerHTML = '';
  }

  form.addEventListener('submit', function (e) {
    e.preventDefault();
    hideError();

    const formData = new FormData(form);

    btn.disabled = true;
    progressWrap.classList.remove('d-none');
    progressBar.style.width = '0%';
    progressPercent.textContent = '0';
    progressText.textContent = 'Preparing upload...';

    const xhr = new XMLHttpRequest();
    xhr.open('POST', form.action, true);

    // Tell Laravel we want JSON
    xhr.setRequestHeader('Accept', 'application/json');

    // CSRF
    const tokenMeta = document.querySelector('meta[name="csrf-token"]');
    if (tokenMeta) xhr.setRequestHeader('X-CSRF-TOKEN', tokenMeta.getAttribute('content'));

    xhr.upload.onprogress = function (event) {
      if (event.lengthComputable) {
        const percent = Math.round((event.loaded / event.total) * 100);
        progressBar.style.width = percent + '%';
        progressPercent.textContent = percent;

        const loadedMB = Math.round(event.loaded / 1024 / 1024);
        const totalMB = Math.round(event.total / 1024 / 1024);
        progressText.textContent = `Uploaded ${loadedMB} MB of ${totalMB} MB`;
      }
    };

    xhr.onload = function () {
      btn.disabled = false;

      let res = null;
      try { res = JSON.parse(xhr.responseText); } catch (e) {}

      // Laravel validation error (422)
      if (xhr.status === 422 && res && res.errors) {
        let html = '<strong>Validation Error:</strong><ul class="mb-0">';
        Object.keys(res.errors).forEach(key => {
          res.errors[key].forEach(m => html += `<li>${m}</li>`);
        });
        html += '</ul>';
        showError(html);
        return;
      }

      // Server too large upload (often 413)
      if (xhr.status === 413) {
        showError('<strong>File too large for server.</strong> Please increase server upload limits (nginx/apache/php.ini).');
        return;
      }

      if (xhr.status === 200 && res && res.success) {
        progressText.textContent = 'Upload completed!';
        window.location.href = res.redirect;
        return;
      }

      showError('<strong>Upload failed.</strong> Please check server limits and try again.');
    };

    xhr.onerror = function () {
      btn.disabled = false;
      showError('<strong>Network/server error.</strong> Please try again.');
    };

    xhr.send(formData);
  });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/upload_apps/create.blade.php ENDPATH**/ ?>