<?php $__env->startSection('title','Upload Apps'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa-solid fa-circle-check me-2"></i><?php echo e(session('success')); ?>

      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Upload Apps</h4>
      <p class="text-muted mb-0">Upload & manage APK files</p>
    </div>

    <a href="<?php echo e(route('upload-apps.create')); ?>" class="btn btn-primary">
      <i class="fa-solid fa-upload me-2"></i>Upload New
    </a>
  </div>

  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <?php if($uploadApps->count() === 0): ?>
        <div class="text-center p-5 text-muted">
          <i class="fa-solid fa-box-open fa-2x mb-2"></i>
          <div class="fw-semibold">No APK uploaded yet</div>
          <div class="small">Click “Upload New” to add your first APK.</div>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>App Name</th>
                <th>APK</th>
                <th>Created</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $uploadApps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-muted"><?php echo e($uploadApps->firstItem() + $i); ?></td>
                  <td class="fw-semibold"><?php echo e($app->app_name ?? '-'); ?></td>

                  <td>
                    <?php if($app->apk_file): ?>
                      <span class="badge bg-success">
                        <i class="fa-brands fa-android me-1"></i>Uploaded
                      </span>
                      <div class="small text-muted mt-1"><?php echo e(basename($app->apk_file)); ?></div>
                    <?php else: ?>
                      <span class="badge bg-secondary">N/A</span>
                    <?php endif; ?>
                  </td>

                  <td class="text-muted"><?php echo e(optional($app->created_at)->format('d M Y')); ?></td>

                  <td class="text-end">
                    <div class="d-flex gap-2 justify-content-end flex-wrap">

                      <a href="<?php echo e(route('upload-apps.show', $app->id)); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="fa-regular fa-eye me-1"></i>View
                      </a>

                      <a href="<?php echo e(route('upload-apps.edit', $app->id)); ?>" class="btn btn-outline-primary btn-sm">
                        <i class="fa-regular fa-pen-to-square me-1"></i>Edit
                      </a>

                      <?php if($app->apk_file): ?>
                        <a href="<?php echo e(route('upload-apps.download', $app->id)); ?>" class="btn btn-outline-success btn-sm">
                          <i class="fa-solid fa-download me-1"></i>Download
                        </a>
                      <?php endif; ?>

                      <form action="<?php echo e(route('upload-apps.destroy', $app->id)); ?>" method="POST"
                            onsubmit="return confirm('Delete this app?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-outline-danger btn-sm">
                          <i class="fa-regular fa-trash-can me-1"></i>Delete
                        </button>
                      </form>

                    </div>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          <?php echo e($uploadApps->links()); ?>

        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home2/serverpo/necwev.serverpoint.top/resources/views/admin/upload_apps/index.blade.php ENDPATH**/ ?>