<?php $__env->startSection('title','Headlines'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-3">

  <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa-solid fa-circle-check me-2"></i><?php echo e(session('success')); ?>

      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Headlines</h4>
      <p class="text-muted mb-0">Manage top & body headlines</p>
    </div>

    <a href="<?php echo e(route('headlines.create')); ?>" class="btn btn-primary">
      <i class="fa-solid fa-plus me-2"></i>Add New
    </a>
  </div>

  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <?php if($headlines->count() === 0): ?>
        <div class="text-center p-5 text-muted">
          <i class="fa-regular fa-newspaper fa-2x mb-2"></i>
          <div class="fw-semibold">No headlines found</div>
          <div class="small">Click “Add New” to create headlines.</div>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Top Headline</th>
                <th>Body Headline</th>
                <th>Created</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $headlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td class="text-muted"><?php echo e($headlines->firstItem() + $i); ?></td>

                  <td style="max-width: 260px;">
                    <div class="fw-semibold text-truncate">
                      <?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->top_headlines), 60)); ?>

                    </div>
                  </td>

                  <td style="max-width: 260px;">
                    <div class="text-truncate">
                      <?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->body_headlines), 60)); ?>

                    </div>
                  </td>

                  <td class="text-muted"><?php echo e(optional($item->created_at)->format('d M Y')); ?></td>

                  <td class="text-end">
                    <div class="d-flex gap-2 justify-content-end flex-wrap">
                      <a href="<?php echo e(route('headlines.show', $item->id)); ?>" class="btn btn-outline-secondary btn-sm">
                        <i class="fa-regular fa-eye me-1"></i>View
                      </a>
                      <a href="<?php echo e(route('headlines.edit', $item->id)); ?>" class="btn btn-outline-primary btn-sm">
                        <i class="fa-regular fa-pen-to-square me-1"></i>Edit
                      </a>
                      <form action="<?php echo e(route('headlines.destroy', $item->id)); ?>" method="POST"
                            onsubmit="return confirm('Delete this headline?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-outline-danger btn-sm">
                          <i class="fa-regular fa-trash-can me-1"></i>Delete
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          <?php echo e($headlines->links()); ?>

        </div>
      <?php endif; ?>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\new-laravel-ppp\necmoneysend\resources\views/admin/headlines/index.blade.php ENDPATH**/ ?>