<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ProfileController;

use App\Http\Controllers\HeadlineController;

use App\Http\Controllers\UploadAppController;

use App\Http\Controllers\SystemInfoController;
use App\Http\Controllers\AdminProfileController;


Route::get('storage-link', function () {
    Artisan::call('storage:link');
});

Route::resource('headlines', HeadlineController::class);



Route::middleware('auth')->group(function () {
    Route::get('/admin/profile', [AdminProfileController::class, 'edit'])->name('admin.profile.edit');
    Route::post('/admin/profile', [AdminProfileController::class, 'updateProfile'])->name('admin.profile.update');

    Route::post('/admin/profile/password', [AdminProfileController::class, 'updatePassword'])->name('admin.profile.password');
});



Route::resource('upload-apps', UploadAppController::class);
Route::get('upload-apps/{upload_app}/download', [UploadAppController::class, 'download'])
    ->name('upload-apps.download');


Route::resource('system-infos', SystemInfoController::class);


Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard',[AdminController::class,'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
