@php
    $systemInfo = \App\Models\SystemInfo::first();
    $appName = $systemInfo ? $systemInfo->company_name : 'Admin Dashboard';
@endphp

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $appName }} - Login</title>

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body{
            min-height:100vh;
            background: radial-gradient(1100px circle at 15% 10%, rgba(13,110,253,.12), transparent 55%),
                        radial-gradient(900px circle at 85% 90%, rgba(25,135,84,.12), transparent 55%),
                        #f6f7fb;
        }
        .auth-wrap{
            min-height:100vh;
            display:flex;
            align-items:center;
            justify-content:center;
            padding:24px 12px;
        }
        .auth-card{
            width:100%;
            max-width: 980px;
            border:0;
            border-radius: 22px;
            overflow:hidden;
            box-shadow: 0 18px 45px rgba(0,0,0,.08);
        }
        .brand-side{
            background: linear-gradient(135deg, rgba(13,110,253,.08), rgba(25,135,84,.06));
        }
        .brand-box{
            padding:28px;
        }
        .brand-logo{
            width: 100%;
            max-width: 240px;
            height: 56px;
            object-fit: contain;
        }
        .brand-title{
            font-weight: 800;
            letter-spacing: .2px;
        }
        .mini{
            font-size:.9rem;
            color:#6c757d;
        }
        .form-side{
            padding:28px;
        }
        .form-control{
            border-radius: 14px;
            padding: 12px 14px;
        }
        .btn-soft{
            border-radius: 14px;
            padding: 12px 14px;
            font-weight: 600;
        }
        .divider{
            height:1px;
            background:rgba(0,0,0,.08);
            margin:16px 0;
        }
        .icon-pill{
            width:44px;height:44px;border-radius:14px;
            display:flex;align-items:center;justify-content:center;
            background: rgba(13,110,253,.10);
            color:#0d6efd;
        }
        @media (max-width: 992px){
            .brand-box{ padding:22px; }
            .form-side{ padding:22px; }
        }
    </style>
</head>

<body>
<div class="auth-wrap">
    <div class="card auth-card">
        <div class="row g-0">

            {{-- LEFT BRAND --}}
            <div class="col-12 col-lg-5 brand-side">
                <div class="brand-box h-100 d-flex flex-column justify-content-between">

                    <div>
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <div class="icon-pill">
                                <i class="fa-solid fa-lock"></i>
                            </div>

                            <div>
                                <div class="brand-title fs-5">{{ $appName }}</div>
                                <div class="mini">Secure Admin Login</div>
                            </div>
                        </div>

                        <div class="bg-white rounded-4 p-3 border">
                            <div class="d-flex justify-content-center">
                                @if(optional($systemInfo)->logo)
                                    <img class="brand-logo"
                                         src="{{ asset('storage/' . $systemInfo->logo) }}"
                                         alt="logo">
                                @else
                                    <img class="brand-logo"
                                         src="{{ asset('assets/logo1.png') }}"
                                         alt="logo">
                                @endif
                            </div>

                            <div class="divider"></div>

                            <ul class="mini mb-0 ps-3">
                                <li>Responsive admin panel</li>
                                <li>App upload & headlines control</li>
                                <li>System settings management</li>
                            </ul>
                        </div>
                    </div>

                    <div class="mini mt-3">
                        <i class="fa-regular fa-circle-check me-2"></i>
                        Use your admin credentials to continue.
                    </div>

                </div>
            </div>

            {{-- RIGHT FORM --}}
            <div class="col-12 col-lg-7 bg-white">
                <div class="form-side">

                    <div class="mb-3">
                        <h4 class="mb-1 fw-bold">Welcome back</h4>
                        <div class="text-muted">Please sign in to your account</div>
                    </div>

                    {{-- Session Status --}}
                    @if (session('status'))
                        <div class="alert alert-success">
                            <i class="fa-solid fa-circle-check me-2"></i>{{ session('status') }}
                        </div>
                    @endif

                    {{-- Validation Errors --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <div class="fw-semibold mb-1">
                                <i class="fa-solid fa-triangle-exclamation me-2"></i>Please fix the following:
                            </div>
                            <ul class="mb-0 ps-3">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-0" style="border-radius:14px 0 0 14px;">
                                    <i class="fa-regular fa-envelope"></i>
                                </span>
                                <input
                                    type="email"
                                    name="email"
                                    value="{{ old('email') }}"
                                    class="form-control border-0 bg-light"
                                    style="border-radius:0 14px 14px 0;"
                                    placeholder="example@email.com"
                                    required
                                    autofocus
                                    autocomplete="username"
                                >
                            </div>
                        </div>

                        <div class="mb-2">
                            <label class="form-label">Password</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-0" style="border-radius:14px 0 0 14px;">
                                    <i class="fa-solid fa-key"></i>
                                </span>
                                <input
                                    type="password"
                                    name="password"
                                    class="form-control border-0 bg-light"
                                    style="border-radius:0 14px 14px 0;"
                                    placeholder="••••••••"
                                    required
                                    autocomplete="current-password"
                                    id="passwordInput"
                                >
                            </div>

                            <div class="form-text">
                                <a href="{{ route('password.request') }}" class="text-decoration-none">
                                    Forgot your password?
                                </a>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mt-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember_me">
                                <label class="form-check-label" for="remember_me">
                                    Remember me
                                </label>
                            </div>

                            <button type="submit" class="btn btn-primary btn-soft">
                                <i class="fa-solid fa-right-to-bracket me-2"></i>Log in
                            </button>
                        </div>
                    </form>

                    <div class="divider"></div>

                    <div class="mini">
                        <i class="fa-regular fa-shield-halved me-2"></i>
                        Your login is protected.
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
