@extends('admin.master')

@section('title','Upload Apps')

@section('content')
<div class="container-fluid py-3">

  @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa-solid fa-circle-check me-2"></i>{{ session('success') }}
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  @endif

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Upload Apps</h4>
      <p class="text-muted mb-0">Upload & manage APK files</p>
    </div>

    <a href="{{ route('upload-apps.create') }}" class="btn btn-primary">
      <i class="fa-solid fa-upload me-2"></i>Upload New
    </a>
  </div>

  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      @if($uploadApps->count() === 0)
        <div class="text-center p-5 text-muted">
          <i class="fa-solid fa-box-open fa-2x mb-2"></i>
          <div class="fw-semibold">No APK uploaded yet</div>
          <div class="small">Click “Upload New” to add your first APK.</div>
        </div>
      @else
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>App Name</th>
                <th>APK</th>
                <th>Created</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($uploadApps as $i => $app)
                <tr>
                  <td class="text-muted">{{ $uploadApps->firstItem() + $i }}</td>
                  <td class="fw-semibold">{{ $app->app_name ?? '-' }}</td>

                  <td>
                    @if($app->apk_file)
                      <span class="badge bg-success">
                        <i class="fa-brands fa-android me-1"></i>Uploaded
                      </span>
                      <div class="small text-muted mt-1">{{ basename($app->apk_file) }}</div>
                    @else
                      <span class="badge bg-secondary">N/A</span>
                    @endif
                  </td>

                  <td class="text-muted">{{ optional($app->created_at)->format('d M Y') }}</td>

                  <td class="text-end">
                    <div class="d-flex gap-2 justify-content-end flex-wrap">

                      <a href="{{ route('upload-apps.show', $app->id) }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fa-regular fa-eye me-1"></i>View
                      </a>

                      <a href="{{ route('upload-apps.edit', $app->id) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fa-regular fa-pen-to-square me-1"></i>Edit
                      </a>

                      @if($app->apk_file)
                        <a href="{{ route('upload-apps.download', $app->id) }}" class="btn btn-outline-success btn-sm">
                          <i class="fa-solid fa-download me-1"></i>Download
                        </a>
                      @endif

                      <form action="{{ route('upload-apps.destroy', $app->id) }}" method="POST"
                            onsubmit="return confirm('Delete this app?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-outline-danger btn-sm">
                          <i class="fa-regular fa-trash-can me-1"></i>Delete
                        </button>
                      </form>

                    </div>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          {{ $uploadApps->links() }}
        </div>
      @endif
    </div>
  </div>
</div>
@endsection
