@extends('admin.master')
@section('title','Edit Uploaded App')

@section('content')
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">
      <h5 class="mb-3"><i class="fa-regular fa-pen-to-square me-2"></i>Edit Uploaded App</h5>

      @if($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach($errors->all() as $e) <li>{{ $e }}</li> @endforeach
          </ul>
        </div>
      @endif

      <form action="{{ route('upload-apps.update', $uploadApp->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="row g-3">
          <div class="col-12 col-lg-6">
            <label class="form-label">App Name</label>
            <input type="text" name="app_name"
                   value="{{ old('app_name', $uploadApp->app_name ?? '') }}"
                   class="form-control @error('app_name') is-invalid @enderror">
            @error('app_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
          </div>

          <div class="col-12 col-lg-6">
            <label class="form-label">Replace APK (optional)</label>
            <input type="file" name="apk_file" accept=".apk"
                   class="form-control @error('apk_file') is-invalid @enderror">
            @error('apk_file') <div class="invalid-feedback">{{ $message }}</div> @enderror

            @if(!empty($uploadApp->apk_file))
              <div class="mt-2">
                <span class="badge bg-success">
                  <i class="fa-brands fa-android me-1"></i>Current APK
                </span>
                <div class="small text-muted mt-1">{{ basename($uploadApp->apk_file) }}</div>
              </div>
            @endif
          </div>
        </div>

        <div class="d-flex gap-2 mt-4 flex-wrap">
          <button class="btn btn-primary">
            <i class="fa-solid fa-floppy-disk me-2"></i>Update
          </button>

          <a href="{{ route('upload-apps.index') }}" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
      </form>

    </div>
  </div>
</div>
@endsection