@extends('admin.master')
@section('title','Upload New App')

@section('content')
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">
      <h5 class="mb-3"><i class="fa-solid fa-upload me-2"></i>Upload New App</h5>

      @if($errors->any())
        <div class="alert alert-danger">
          <ul class="mb-0">
            @foreach($errors->all() as $e) <li>{{ $e }}</li> @endforeach
          </ul>
        </div>
      @endif

      <form action="{{ route('upload-apps.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row g-3">
          <div class="col-12 col-lg-6">
            <label class="form-label">App Name</label>
            <input type="text" name="app_name"
                   value="{{ old('app_name') }}"
                   class="form-control @error('app_name') is-invalid @enderror">
            @error('app_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
          </div>

          <div class="col-12 col-lg-6">
            <label class="form-label">APK File</label>
            <input type="file" name="apk_file" required
                   class="form-control @error('apk_file') is-invalid @enderror">
            @error('apk_file') <div class="invalid-feedback">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="d-flex gap-2 mt-4 flex-wrap">
          <button class="btn btn-primary">
            <i class="fa-solid fa-floppy-disk me-2"></i>Save
          </button>

          <a href="{{ route('upload-apps.index') }}" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
      </form>

    </div>
  </div>
</div>
@endsection