@extends('admin.master')

@section('title','System Infos')

@section('content')
<div class="container-fluid py-3">

  @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <i class="fa-solid fa-circle-check me-2"></i>{{ session('success') }}
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  @endif

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">System Infos</h4>
    
    </div>

    <a href="{{ route('system-infos.create') }}" class="btn btn-primary">
      <i class="fa-solid fa-plus me-2"></i>Add New
    </a>
  </div>

  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      @if($systemInfos->count() === 0)
        <div class="text-center p-5 text-muted">
          <i class="fa-regular fa-folder-open fa-2x mb-2"></i>
          <div class="fw-semibold">No records yet</div>
          <div class="small">Click “Add New” to create your first system info.</div>
        </div>
      @else
        <div class="table-responsive">
          <table class="table align-middle mb-0">
            <thead class="table-light">
              <tr>
                <th>#</th>
                <th>Company</th>
                <th>Logo</th>
                <th>Favicon</th>
                <th>Phone</th>
                <th>Whatsapp</th>
                <th class="text-end">Actions</th>
              </tr>
            </thead>

            <tbody>
              @foreach($systemInfos as $i => $info)
                <tr>
                  <td class="text-muted">{{ $systemInfos->firstItem() + $i }}</td>
                  <td class="fw-semibold">{{ $info->company_name ?? '-' }}</td>

                  <td>
                    @if($info->logo)
                      <img src="{{ asset('storage/'.$info->logo) }}" alt="logo"
                           style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
                    @else
                      <span class="badge bg-secondary">N/A</span>
                    @endif
                  </td>

                  <td>
                    @if($info->favicon)
                      <img src="{{ asset('storage/'.$info->favicon) }}" alt="favicon"
                           style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
                    @else
                      <span class="badge bg-secondary">N/A</span>
                    @endif
                  </td>

                  <td>{{ $info->phone ?? '-' }}</td>
                  <td>{{ $info->whatsapp_number ?? '-' }}</td>

                  <td class="text-end">
                    <div class="d-flex gap-2 justify-content-end flex-wrap">
                      <a href="{{ route('system-infos.show', $info->id) }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fa-regular fa-eye me-1"></i>View
                      </a>

                      <a href="{{ route('system-infos.edit', $info->id) }}" class="btn btn-outline-primary btn-sm">
                        <i class="fa-regular fa-pen-to-square me-1"></i>Edit
                      </a>

                      <form action="{{ route('system-infos.destroy', $info->id) }}" method="POST"
                            onsubmit="return confirm('Delete this record?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger btn-sm">
                          <i class="fa-regular fa-trash-can me-1"></i>Delete
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              @endforeach
            </tbody>
          </table>
        </div>

        <div class="mt-3">
          {{ $systemInfos->links() }}
        </div>
      @endif

    </div>
  </div>
</div>
@endsection
