@php $isEdit = isset($systemInfo); @endphp

<div class="row g-3">
  <div class="col-12 col-lg-6">
    <label class="form-label">Company Name</label>
    <input type="text" name="company_name"
           value="{{ old('company_name', $systemInfo->company_name ?? '') }}"
           class="form-control @error('company_name') is-invalid @enderror"
           placeholder="e.g. Techmiraj">
    @error('company_name') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12 col-lg-6">
    <label class="form-label">Phone</label>
    <input type="text" name="phone"
           value="{{ old('phone', $systemInfo->phone ?? '') }}"
           class="form-control @error('phone') is-invalid @enderror"
           placeholder="+880...">
    @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12 col-lg-6">
    <label class="form-label">WhatsApp Number</label>
    <input type="text" name="whatsapp_number"
           value="{{ old('whatsapp_number', $systemInfo->whatsapp_number ?? '') }}"
           class="form-control @error('whatsapp_number') is-invalid @enderror"
           placeholder="+880...">
    @error('whatsapp_number') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12 col-lg-6">
    <label class="form-label">Email</label>
    <input type="text" name="address"
           value="{{ old('address', $systemInfo->address ?? '') }}"
           class="form-control @error('address') is-invalid @enderror"
           placeholder="Company Email">
    @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12">
    <label class="form-label">Footer Copy Right</label>
    <input type="text" name="footer_copey_right"
           value="{{ old('footer_copey_right', $systemInfo->footer_copey_right ?? '') }}"
           class="form-control @error('footer_copey_right') is-invalid @enderror"
           placeholder="© 2026 Your Company. All rights reserved.">
    @error('footer_copey_right') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12 col-lg-6">
    <label class="form-label">Logo</label>
    <input type="file" name="logo" class="form-control @error('logo') is-invalid @enderror" accept="image/*">
    @error('logo') <div class="invalid-feedback">{{ $message }}</div> @enderror

    @if($isEdit && !empty($systemInfo->logo))
      <div class="mt-2 d-flex align-items-center gap-2 flex-wrap">
        <img src="{{ asset('storage/'.$systemInfo->logo) }}" style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
        <span class="text-muted small">Current logo</span>
      </div>
    @endif
  </div>

  <div class="col-12 col-lg-6">
    <label class="form-label">Favicon</label>
    <input type="file" name="favicon" class="form-control @error('favicon') is-invalid @enderror" accept="image/*">
    @error('favicon') <div class="invalid-feedback">{{ $message }}</div> @enderror

    @if($isEdit && !empty($systemInfo->favicon))
      <div class="mt-2 d-flex align-items-center gap-2 flex-wrap">
        <img src="{{ asset('storage/'.$systemInfo->favicon) }}" style="width:42px;height:42px;object-fit:cover;border-radius:10px;border:1px solid rgba(0,0,0,.08);">
        <span class="text-muted small">Current favicon</span>
      </div>
    @endif
  </div>
</div>

<div class="d-flex gap-2 mt-4 flex-wrap">
  <button class="btn btn-primary">
    <i class="fa-solid fa-floppy-disk me-2"></i>{{ $isEdit ? 'Update' : 'Save' }}
  </button>
  <a href="{{ route('system-infos.index') }}" class="btn btn-outline-secondary">
    <i class="fa-solid fa-arrow-left me-2"></i>Back
  </a>
</div>
