@extends('admin.master')

@section('title','Admin Profile')

@section('content')
<div class="container-fluid py-3">

  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Admin Profile</h4>
      <p class="text-muted mb-0">Update info & change password</p>
    </div>
  </div>

  <div class="row g-3">
    {{-- Profile Update --}}
    <div class="col-12 col-lg-6">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <h5 class="mb-3">
            <i class="fa-regular fa-user me-2"></i>Update Profile Info
          </h5>

          @if(session('success_profile'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <i class="fa-solid fa-circle-check me-2"></i>{{ session('success_profile') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <form action="{{ route('admin.profile.update') }}" method="POST">
            @csrf

            <div class="mb-3">
              <label class="form-label">Name</label>
              <input type="text" name="name"
                     value="{{ old('name', $user->name) }}"
                     class="form-control @error('name') is-invalid @enderror">
              @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email"
                     value="{{ old('email', $user->email) }}"
                     class="form-control @error('email') is-invalid @enderror">
              @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <button class="btn btn-primary w-100">
              <i class="fa-solid fa-floppy-disk me-2"></i>Save Changes
            </button>
          </form>
        </div>
      </div>
    </div>

    {{-- Password Change --}}
    <div class="col-12 col-lg-6">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <h5 class="mb-3">
            <i class="fa-solid fa-lock me-2"></i>Change Password
          </h5>

          @if(session('success_password'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <i class="fa-solid fa-circle-check me-2"></i>{{ session('success_password') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <form action="{{ route('admin.profile.password') }}" method="POST">
            @csrf

            <div class="mb-3">
              <label class="form-label">Old Password</label>
              <input type="password" name="old_password"
                     class="form-control @error('old_password') is-invalid @enderror"
                     placeholder="Enter old password">
              @error('old_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
              <label class="form-label">New Password</label>
              <input type="password" name="new_password"
                     class="form-control @error('new_password') is-invalid @enderror"
                     placeholder="Enter new password">
              @error('new_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
              <label class="form-label">Confirm Password</label>
              <input type="password" name="new_password_confirmation"
                     class="form-control"
                     placeholder="Re-type new password">
            </div>

            <button class="btn btn-dark w-100">
              <i class="fa-solid fa-key me-2"></i>Change Password
            </button>
          </form>

          <div class="text-muted small mt-3">
            Tip: use at least 6 characters (better 8+).
          </div>

        </div>
      </div>
    </div>
  </div>
</div>
@endsection
