@extends('admin.master')

@section('title','View Headline')

@section('content')
<div class="container-fluid py-3">
  <div class="card border-0 shadow-sm rounded-4">
    <div class="card-body">

      <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
        <div>
          <h5 class="mb-1"><i class="fa-regular fa-eye me-2"></i>Headline Details</h5>
          <p class="text-muted mb-0">Full view</p>
        </div>

        <div class="d-flex gap-2 flex-wrap">
          <a href="{{ route('headlines.edit', $headline->id) }}" class="btn btn-outline-primary">
            <i class="fa-regular fa-pen-to-square me-1"></i>Edit
          </a>
          <a href="{{ route('headlines.index') }}" class="btn btn-outline-secondary">
            <i class="fa-solid fa-arrow-left me-1"></i>Back
          </a>
        </div>
      </div>

      <hr>

      <div class="row g-3">
        <div class="col-12">
          <div class="fw-semibold text-muted mb-1">Top Headlines</div>
          <div class="p-3 bg-light rounded-3">{!! nl2br(e($headline->top_headlines)) !!}</div>
        </div>

        <div class="col-12">
          <div class="fw-semibold text-muted mb-1">Body Headlines</div>
          <div class="p-3 bg-light rounded-3">{!! nl2br(e($headline->body_headlines)) !!}</div>
        </div>
      </div>

    </div>
  </div>
</div>
@endsection
