@php $isEdit = isset($headline); @endphp

<div class="row g-3">
  <div class="col-12">
    <label class="form-label">Top Headlines</label>
    <textarea name="top_headlines" rows="4"
              class="form-control @error('top_headlines') is-invalid @enderror"
              placeholder="Write top headlines...">{{ old('top_headlines', $headline->top_headlines ?? '') }}</textarea>
    @error('top_headlines') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>

  <div class="col-12">
    <label class="form-label">Body Headlines</label>
    <textarea name="body_headlines" rows="6"
              class="form-control @error('body_headlines') is-invalid @enderror"
              placeholder="Write body headlines...">{{ old('body_headlines', $headline->body_headlines ?? '') }}</textarea>
    @error('body_headlines') <div class="invalid-feedback">{{ $message }}</div> @enderror
  </div>
</div>

<div class="d-flex gap-2 mt-4 flex-wrap">
  <button class="btn btn-primary">
    <i class="fa-solid fa-floppy-disk me-2"></i>{{ $isEdit ? 'Update' : 'Save' }}
  </button>

  <a href="{{ route('headlines.index') }}" class="btn btn-outline-secondary">
    <i class="fa-solid fa-arrow-left me-2"></i>Back
  </a>
</div>
