@extends('admin.master')

@section('title','Dashboard')

@section('content')
<div class="container-fluid py-3">

  {{-- Header --}}
  <div class="d-flex justify-content-between align-items-start flex-wrap gap-2 mb-3">
    <div>
      <h4 class="mb-1">Dashboard</h4>
      <p class="text-muted mb-0">Quick overview of your system</p>
    </div>

    {{-- Quick actions --}}
    <div class="d-flex gap-2 flex-wrap">
      <a href="{{ route('upload-apps.create') }}" class="btn btn-primary">
        <i class="fa-solid fa-upload me-2"></i>Upload App
      </a>
      <a href="{{ route('headlines.create') }}" class="btn btn-outline-primary">
        <i class="fa-regular fa-newspaper me-2"></i>Add Headline
      </a>
      <a href="{{ route('system-infos.create') }}" class="btn btn-outline-secondary">
        <i class="fa-solid fa-gear me-2"></i>System Info
      </a>
    </div>
  </div>

  {{-- Stats cards --}}
  <div class="row g-3 mb-3">
    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Total Users</div>
            <div class="fs-3 fw-bold">{{ $totalUsers }}</div>
          </div>
          <div class="fs-2 text-primary">
            <i class="fa-solid fa-users"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="#" class="small text-decoration-none">
            Manage Users <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Uploaded Apps</div>
            <div class="fs-3 fw-bold">{{ $totalApps }}</div>
          </div>
          <div class="fs-2 text-success">
            <i class="fa-brands fa-android"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="{{ route('upload-apps.index') }}" class="small text-decoration-none">
            View Apps <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">Headlines</div>
            <div class="fs-3 fw-bold">{{ $totalHeadlines }}</div>
          </div>
          <div class="fs-2 text-warning">
            <i class="fa-regular fa-newspaper"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="{{ route('headlines.index') }}" class="small text-decoration-none">
            View Headlines <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-6 col-xl-3">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted small">System Infos</div>
            <div class="fs-3 fw-bold">{{ $totalSystemInfo }}</div>
          </div>
          <div class="fs-2 text-secondary">
            <i class="fa-solid fa-gear"></i>
          </div>
        </div>
        <div class="card-footer bg-transparent border-0 pt-0">
          <a href="{{ route('system-infos.index') }}" class="small text-decoration-none">
            View Settings <i class="fa-solid fa-arrow-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>
  </div>

  {{-- Main content --}}
  <div class="row g-3">

    {{-- System Info Preview --}}
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <h6 class="fw-semibold mb-3">
            <i class="fa-solid fa-building me-2"></i>Company Info
          </h6>

          @if($systemInfo)
            <div class="d-flex align-items-center gap-3 mb-3">
              @if($systemInfo->logo)
                <img src="{{ asset('storage/'.$systemInfo->logo) }}"
                     style="width:54px;height:54px;object-fit:cover;border-radius:14px;border:1px solid rgba(0,0,0,.08);">
              @else
                <div class="bg-light d-flex align-items-center justify-content-center"
                     style="width:54px;height:54px;border-radius:14px;">
                  <i class="fa-solid fa-image text-muted"></i>
                </div>
              @endif

              <div>
                <div class="fw-bold">{{ $systemInfo->company_name ?? 'N/A' }}</div>
                <div class="small text-muted">{{ $systemInfo->address ?? 'No address' }}</div>
              </div>
            </div>

            <div class="small">
              <div class="mb-2">
                <i class="fa-solid fa-phone me-2 text-muted"></i>{{ $systemInfo->phone ?? '-' }}
              </div>
              <div class="mb-2">
                <i class="fa-brands fa-whatsapp me-2 text-muted"></i>{{ $systemInfo->whatsapp_number ?? '-' }}
              </div>
              <div class="text-muted">
                <i class="fa-regular fa-copyright me-2"></i>{{ $systemInfo->footer_copey_right ?? '-' }}
              </div>
            </div>

          @else
            <div class="text-center p-4 text-muted">
              <i class="fa-solid fa-circle-info fa-2x mb-2"></i>
              <div class="fw-semibold">No system info added</div>
              <div class="small">Add company settings to show here.</div>
              <a href="{{ route('system-infos.create') }}" class="btn btn-sm btn-outline-secondary mt-3">
                <i class="fa-solid fa-plus me-1"></i>Add System Info
              </a>
            </div>
          @endif
        </div>
      </div>
    </div>

    {{-- Latest Apps --}}
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-brands fa-android me-2"></i>Latest Apps
            </h6>
            <a href="{{ route('upload-apps.index') }}" class="small text-decoration-none">View all</a>
          </div>

          @forelse($latestApps as $app)
            <div class="d-flex justify-content-between align-items-start py-2 border-bottom">
              <div>
                <div class="fw-semibold">{{ $app->app_name ?? 'Untitled App' }}</div>
                <div class="small text-muted">
                  {{ $app->created_at?->format('d M Y') }}
                </div>
              </div>

              @if($app->apk_file)
                <a class="btn btn-sm btn-outline-success"
                   href="{{ route('upload-apps.download', $app->id) }}">
                  <i class="fa-solid fa-download"></i>
                </a>
              @endif
            </div>
          @empty
            <div class="text-center p-4 text-muted">
              <i class="fa-solid fa-box-open mb-2"></i>
              <div>No apps uploaded yet</div>
            </div>
          @endforelse

        </div>
      </div>
    </div>

    {{-- Latest Headlines --}}
    <div class="col-12 col-lg-4">
      <div class="card border-0 shadow-sm rounded-4 h-100">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-regular fa-newspaper me-2"></i>Latest Headlines
            </h6>
            <a href="{{ route('headlines.index') }}" class="small text-decoration-none">View all</a>
          </div>

          @forelse($latestHeadlines as $h)
            <div class="py-2 border-bottom">
              <div class="fw-semibold text-truncate">
                {{ \Illuminate\Support\Str::limit(strip_tags($h->top_headlines), 60) }}
              </div>
              <div class="small text-muted">
                {{ \Illuminate\Support\Str::limit(strip_tags($h->body_headlines), 70) }}
              </div>
            </div>
          @empty
            <div class="text-center p-4 text-muted">
              <i class="fa-regular fa-newspaper mb-2"></i>
              <div>No headlines added yet</div>
            </div>
          @endforelse

        </div>
      </div>
    </div>

    {{-- Latest Users table --}}
    <div class="col-12">
      <div class="card border-0 shadow-sm rounded-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h6 class="fw-semibold mb-0">
              <i class="fa-solid fa-users me-2"></i>Latest Users
            </h6>
          </div>

          <div class="table-responsive">
            <table class="table align-middle mb-0">
              <thead class="table-light">
                <tr>
                  <th>#</th>
                  <th>Name</th>
                  <th>Email</th>
                  <th>Joined</th>
                </tr>
              </thead>
              <tbody>
                @forelse($latestUsers as $i => $u)
                  <tr>
                    <td class="text-muted">{{ $i + 1 }}</td>
                    <td class="fw-semibold">{{ $u->name }}</td>
                    <td>{{ $u->email }}</td>
                    <td class="text-muted">{{ $u->created_at?->format('d M Y') }}</td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="text-center text-muted p-4">
                      No users found
                    </td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>

  </div>
</div>
@endsection
