<?php

namespace App\Http\Controllers;

use App\Models\Headline;
use Illuminate\Http\Request;

class HeadlineController extends Controller
{
    public function index()
    {
        $headlines = Headline::latest()->paginate(10);
        return view('admin.headlines.index', compact('headlines'));
    }

    public function create()
    {
        return view('admin.headlines.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'top_headlines'  => ['nullable', 'string'],
            'body_headlines' => ['nullable', 'string'],
        ]);

        Headline::create($data);

        return redirect()->route('headlines.index')->with('success', 'Headline created successfully.');
    }

    public function show(Headline $headline)
    {
        return view('admin.headlines.show', compact('headline'));
    }

    public function edit(Headline $headline)
    {
        return view('admin.headlines.edit', compact('headline'));
    }

    public function update(Request $request, Headline $headline)
    {
        $data = $request->validate([
            'top_headlines'  => ['nullable', 'string'],
            'body_headlines' => ['nullable', 'string'],
        ]);

        $headline->update($data);

        return redirect()->route('headlines.index')->with('success', 'Headline updated successfully.');
    }

    public function destroy(Headline $headline)
    {
        $headline->delete();
        return redirect()->route('headlines.index')->with('success', 'Headline deleted successfully.');
    }
}
