<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Headline;
use App\Models\UploadApp;
use App\Models\SystemInfo;

class AdminController extends Controller
{
    public function index()
    {
        $totalUsers      = User::count();
        $totalApps       = UploadApp::count();
        $totalHeadlines  = Headline::count();
        $totalSystemInfo = SystemInfo::count();

        $latestUsers = User::latest()->take(5)->get();
        $latestApps  = UploadApp::latest()->take(5)->get();
        $latestHeadlines = Headline::latest()->take(5)->get();

        $systemInfo = SystemInfo::latest()->first();

        return view('admin.dashboard', compact(
            'totalUsers',
            'totalApps',
            'totalHeadlines',
            'totalSystemInfo',
            'latestUsers',
            'latestApps',
            'latestHeadlines',
            'systemInfo'
        ));
    }
}
